////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>

@class PasswordError;

/**
 * Interface to implement in order to receive events related to local authentication.
 */
NS_REFINED_FOR_SWIFT
@protocol LocalAuthenticationDelegate <NSObject>

/**
 * Called upon local authentication success.
 *
 * @param otp the generated one-time password
 * @param hostCode the generated host code
 */
- (void)onLocalAuthenticationSuccessWithOTP:(NSString *)otp andHostCode:(NSString *)hostCode;

/**
 * Called upon local authentication abortion
 */
- (void)onLocalAuthenticationAborted;

/**
 * Called upon password error when performing local authentication.
 *
 * @param error the type of password error
 */
- (void)onLocalAuthenticationPasswordError:(PasswordError*)error;

@end
